'=============================================================================
'                           RAYCASTING TUTORIAL #4
'                                By Joe King
'
'                             A choppy raycaster
'=============================================================================

'   Now that you've read tutorials #1,#2, and #3, and understood them, let's
' build a 3d raycasting engine.  I've put lot's of REM statements in here,
' even in the stupid places that you might know what it's doing.
'   This raycaster is choppy since each wall strip is 5 pixels wide.

'***** The code *****
'=============================================================================

  DIM SinTable(359) AS INTEGER    '***** The run table for the slope.
  DIM CosTable(359) AS INTEGER    '***** The rise table for the slope.
                                  '***** Make them integers to add faster.

  CONST PI = 22 / 7               '***** The Pi constant 3.14159 or 22/7

  DIM Map%(10, 10)                '***** Our map grid we are going to use.

'***** Calculate our slope tables.  Sine is the run of the slope, and cosine
'***** is the run of the slopes.  Then times them by 100, so when they round
'***** off, they don't all = 1 or 0.
FOR z% = 0 TO 359
  SinTable(z%) = SIN(z% * PI / 180) * 100
  CosTable(z%) = COS(z% * PI / 180) * 100
NEXT z%

'***** Read the map data, and put it into the Map% array
'***** If the part of the map equals 2 then get the player's coordinates and
'***** make the part of the map equal 0(nothing).
FOR y% = 1 TO 10
FOR x% = 1 TO 10
  READ Map%(x%, y%)
    IF Map%(x%, y%) = 2 THEN
      Map%(x%, y%) = 0
      px% = x%: py% = y%
    END IF
NEXT x%
NEXT y%

'***** Times the player's coordinates by 100 for purposes explained in
'***** tutorial #3
px% = px% * 1000
py% = py% * 1000


  SCREEN 13               '***** Put it into graphics mode so we can draw
                          '***** lines.

  Angle% = 0              '***** The angle you are facing at.

  SkyColor% = 9           '***** The color of the sky.
  WallColor% = 15         '***** The color of the walls.
  FloorColor% = 2         '***** The color of the floor.

  DO
 
  GOSUB Raycast           '***** Gosub the raycasting routine.

  DO                      '***** This makes a DO...LOOP, and waits for a key
    a$ = INKEY$           '***** to be pressed.
  LOOP UNTIL a$ <> ""

  '***** If you press '' then move up.  Do this by subtracting your x and y
  '***** position by the run and rise of your angle.
  IF a$ = CHR$(0) + "H" THEN px% = px% - SinTable(Angle%) * 5: py% = py% - CosTable(Angle%) * 5
  '***** If you press '' then move down.  Do this by adding your x and y
  '***** position by the run and rise of your angle.
  IF a$ = CHR$(0) + "P" THEN px% = px% + SinTable(Angle%) * 5: py% = py% + CosTable(Angle%) * 5

  IF a$ = CHR$(0) + "M" THEN Angle% = Angle% + 5  '***** Add the angle or
  IF a$ = CHR$(0) + "K" THEN Angle% = Angle% - 5  '***** subtract it by which
                                                  '***** key you pressed

  IF a$ = CHR$(27) THEN END   '***** End the program if you pressed 'Esc'

  '***** Make sure that your angle dosen't go below 0 or above 359
  IF Angle% < 0 THEN Angle% = Angle% + 360
  IF Angle% > 359 THEN Angle% = Angle% - 360

  LOOP  '***** Loop back to the start



'***** The raycasting routine *****
Raycast:

s% = -5:    '***** This is the spot where we are going to draw our line.  It's
            '***** at -5 because we will add it by 5 and make it 0, then 5,10,
            '***** 15,20,etc.

'***** Start of FOR...NEXT loop for casting out rays for our F.O.V.
'***** We will cast out 30 degrees to the left and 30 degrees to the right,
'***** but remember we need a 64 F.O.V. to cover the entire screen, so we will
'***** cast out 31 degrees to the left and 32 degrees to the right(your
'***** probaly thinking that 31+32=63, not 64, we include angle 0 for casting
'***** out a ray also).
FOR z% = -31 TO 32

s% = s% + 5   '***** Add the spot where we are going to draw our vertical
              '***** strip.

a% = Angle% + z%  '***** The angle that we are going to cast out our ray. It's
                  '***** the angle your facing at plus the angle for out
                  '***** F.O.V.

IF a% < 0 THEN a% = a% + 360    '***** Make sure that the angle we are casting
IF a% > 359 THEN a% = a% - 360  '***** at isn't smaller than 0 or bigger than
                                '***** 359, is it is, we add it or subtract it
                                '***** by 360 to get the next angle of our
                                '***** ray.  -2+360 = 358, 365-360 = 5.

xx% = px%: yy% = py%  '***** Make the coordinates that we will add our slopes
                      '***** by for our ray so we don't change the player's
                      '***** coordinates.

dd% = 0   '***** This is the distance counter, make it 0 to start counting
          '***** when you cast out your ray.

'***** This is where we cast out our ray.  We add yy% by the rise, and xx%
'***** by then run.  But I subtract it so that angle 0 is infront of you.
DO
  xx% = xx% - SinTable(a%)
  yy% = yy% - CosTable(a%)
  m% = Map%(xx% \ 1000, yy% \ 1000) '***** Make m% = Map(RAYX/100,RAYY/100) to
                                  '***** check if you hit a wall on the map
                                  '***** grid.  I use '\' instead if '/',
                                  '***** because '\' divides faster.
  dd% = dd% + 1 '***** Count the distance up to count how far the ray goes
LOOP UNTIL m%   '***** Loop until m% is true(until m%<>0)

ds% = 1000 / dd%    '***** Makes ds%(distance) 1000/dd%, so if the distance
                    '***** is far, we make it small, and if it's close, make
                    '***** it big. Example/ dd% = 50, ds% = 1000/50, ds% = 20
                    '***** 1000/dd% works fine, you could change the 1000 and
                    '***** see what happens.

'***** We want to draw from to top down to the top of the wall, if you take
'***** this line out, you'll get a blurry effect.
LINE (s%, 0)-(s% + 4, 99 - ds%), SkyColor%, BF
'***** We draw from the center up to the center down to draw our wall.  And
'***** go from s% to s% + 4 which is 5 pixels for the strip of the wall.
LINE (s%, 100 - ds%)-(s% + 4, 100 + ds%), WallColor%, BF
'***** Now we want to draw from the bottom of the wall down to the bottom of
'***** the screen.
LINE (s%, 101 + ds%)-(s% + 4, 199), FloorColor%, BF


NEXT z%

RETURN


'***** This is the data for the map that we read and put it into the Map%
'***** array.

DATA 1,1,1,1,1,1,1,1,1,1
DATA 1,0,0,0,0,0,0,0,0,1
DATA 1,0,0,1,0,1,1,1,0,1
DATA 1,1,1,1,0,0,0,1,0,1
DATA 1,0,0,0,0,0,0,1,0,1
DATA 1,0,0,0,0,2,0,0,0,1
DATA 1,1,1,1,0,1,0,0,0,1
DATA 1,0,0,0,0,1,0,1,0,1
DATA 1,0,1,1,1,1,0,0,0,1
DATA 1,1,1,1,1,1,1,1,1,1

'***** End of code *****
'=============================================================================

'   I hope you get how this works.  You could probaly build your own now.  If
' you can't, keep on trying.  It took me some time to build my own.  You'll
' get it soon enough.



